
## Traditional Network Operations

- Historically, network operation involves manual, device-by-device configuration (often with a text editor like Notepad).
- Challenges with manual methods:
    - Speed is limited by human interaction.
    - Manual copying/pasting is error-prone, especially at scale.
    - Tasks are not easily repeatable, leading to inefficient workflows.

## Benefits of Modern Network Automation

- Adopting software development tools (e.g., version control) improves workflows:
    - Configurations are versioned, tracked, and serve as a source of truth.
    - Changes are tested automatically before deployment, reducing errors.

---

## Uses of Network Automation

- **Device Provisioning:**
    
    - Faster, more efficient device configuration.
    - Fewer human errors due to reduced manual interaction.
- **Data Collection & Telemetry:**
    
    - Real-time streaming of data from devices (e.g., IOS-XR).
    - More efficient and timely network monitoring.
- **Compliance Checks:**
    
    - Rapid auditing of device configurations.
    - Automated correction of errors with regression tests.
- **Reporting:**
    
    - Automated extraction and aggregation of data for reporting.
    - Reduces manual effort in report generation.
- **Troubleshooting:**
    
    - Automated configuration analysis and error checking.
    - Faster diagnosis across multiple devices.

---

## Network Automation Scenarios

- **Device Information Audit:**
    
    - Automated collection of hostnames, IPs, platforms, and serial numbers (e.g., for Cisco ISE deployment).
    - Replaces manual, error-prone spreadsheet entry with automated data gathering.
- **Urgent Device Provisioning:**
    
    - Rapid deployment of access control lists (ACLs) to many firewalls (e.g., for security vulnerability mitigation).
    - Ensures speed, accuracy, and built-in validation.
- **Firewall Device Management:**
    
    - Automate registration or deregistration of devices in Cisco Secure Firewall Management Center.
    - Simplifies policy application and device lifecycle management.

---

## Network Automation and the Management Plane

- **Traditional Methods:**
    
    - SNMP, Telnet, and SSH were the main management tools.
- **Modern Approach:**
    
    - APIs enable flexible, scalable management.
    - API transport mechanisms include SSH, HTTP, HTTPS.
- **Common Programmatic APIs:**
    
    - NX-API
    - REST
    - NETCONF
    - RESTCONF
    - gRPC
- **Advantages:**
    
    - Structured outputs (e.g., JSON, XML) eliminate manual parsing.
    - Configurations are transactional—applied in full or not at all.

---

## Open-Source Tools and Enterprise Platforms

- **System Operations Tools:**
    
    - Commercial: VMware vCenter, Microsoft System Center, Citrix XenServer.
    - Open Source: Ansible, Puppet, SaltStack, Chef.
- **Cisco Network Automation Platforms:**
    
    - Cisco ACI
    - Cisco Catalyst Center
    - Cisco UCS Director & UCS Manager
    - Cisco NSO
- **Programming Foundations:**
    
    - Underpinned by Linux.
    - Use Python or Ruby for automation scripts.

---

## Network Programmability Technology

- **Core Technologies:**
    - **Linux:** Foundation for tools, scripting, and version control.
    - **Device and Controller APIs:** Essential for automating and managing network devices.
    - **Version Control:** (e.g., Git) For tracking and collaborating on configurations.
    - **Software Development:** Understanding processes for customizing tools.
    - **Automated Testing:** Ensures predictability and reliability of changes.
    - **Continuous Integration (CI):** Automates testing and deployment cycles.

---

## Network Automation Workflow Example

- **Typical Automated Workflow Steps:**
    
    1. Pull the latest configurations from version control (Git main/master branch).
    2. Identify and fix required changes in a new branch.
    3. Submit a pull request for review and merging.
    4. Automated tests run on proposed changes.
    5. Senior engineers review and approve changes.
    6. Deploy configuration to production devices (manual or automated step).
- **Key Points:**
    
    - Automated testing can detect subtle errors.
    - Even if final deployment is manual, significant automation benefits can be realized in earlier stages.